/** Contains static methods for updating arrays */
public class UpdatingArrays {
         
   /** b[h..k-1] is sorted, and b[k] contains a value
       Sort b[h..k] */
   public static void insertValue(int[] b, int h, int k) {
      int v= b[k];
      int i= k;
      /* inv P: (1) Placing v in b[i] makes b[h..k] a
                    permutation of its initial value
                (2) b[h..k] with b[i] removed is initial b[h..k-1]
                (3) v < b[i+1..k]
                */
      while ((i != h) && v < b[i-1]) {
         b[i]= b[i-1];
         i= i-1;
      }
      b[i]= v;
   }
   
   /** b[h..k] has at least three elements. Let x be 
      the value initially in b[h]. Permute b[h..k]
      and return integer j satisfying R:
    
         b[h..j-1] <= b[j] = x <= b[j+1..k]
      */
   public static int partition(int[] b, int h, int k) {
      // {Q: Let x be the value initially in b[h]}
      int j;
      // Truthify R1: b[h+1..j] <= b[h] = x <= b[j+1..k];
         int i= h+1; j= k;
         // {inv P: b[h+1..i-1] <= b[h] = x <= b[j+1..k]}
         while (i <= j) {
            if (b[i] <= b[h]) i= i+1;
            else if (b[j] >= b[h]) j= j-1;
            else {// {b[j] < x < b[i]}
               int t1= b[i]; b[i]= b[j]; b[j]= t1;
               i= i+1; j= j-1;
            }
          }
      int t= b[h]; b[h]= b[j]; b[j]= t;
      // {R}
      return j;
   }
   
   /** Permute b[h], b[(h+k)/2], and b[k] to put their median in b[h] */
   public static void medianOf3(int[] b, int h, int k) {
      int e= (h+k)/2;  // index of middle element of array
      int m;           // index of median
      // Return if b[h] is median; else store index of median in m
         if (b[h] <= b[e]) {
            if (b[h] >= b[k]) return;
            // {b[h] is smallest of the three}
            if (b[e] <= b[k]) m= e;
            else m= k;
         }
         else {
            if (b[h] <= b[k]) return;
            // {b[h] is largest of the three}
            if (b[e] <= b[k]) m= k;
            else m= e;
         }
      int t= b[h]; b[h]= b[m]; b[m]= t;
   }
   
   /** = a copy of array segment b[h..k] */
   public static int[] copy(int[] b, int h, int k) {
      int[] c= new int[k+1-h];
      // inv: b[h..i-1] has been copied to c[0..i-h-1]
      for (int i= h; i != k+1; i++) 
         {c[i-h]= b[i];}
      return c;
   }
   
   /** Segments b[h..e] and b[e+1..k] are already sorted.
       Permute their values so that b[h..k] is sorted.
      */
   public static void merge (int b[], int h, int e, int k) {
      int[] c= copy(b,h,e);
      // {c is a copy of original b[h..e]}
      int i= h; int j= e+1; int m= 0;
      /* inv: b[h..i-1] contains its final, sorted values
         b[j..k] remains to be transferred
         c[m..e-h] remains to be transferred
         */
      for (i= h; i != k+1; i++) {
         if (j <= k && (m > e-h || b[j] <= c[m]))
            {b[i]= b[j]; j= j+1;}
         else
            {b[i]= c[m]; m= m+1;}
      }
   }   
}
